<?
class layout {
	private $html_element;
	public function __construct($html_element) {
		$this->html_element = $html_element;
	}
	private $contains_inline_elements = false;
	private $inline_children = [];
	private $stack_boxes = [];
	public function has_stack_boxes() {
		if($this->stack_boxes->length > 0) {
			return true;
		}
		return false;
	}

	public function reset_auto_height() {
		$max_height = 0;
		foreach($this->html_element->get_children() as $child) {
			$set_height = $child->get_layout_calculator()->get_box()['outest']['set_height'];
			if($set_height > $max_height) {
				$max_height = $set_height;
			}
		}
		$this->html_element->set_style(['height' => ['value' => $max_height, 'type' => 'px']]);
		/*$this->html_element->get_layout()->reset_auto_height($max_height);*/
	}

	public function find_inline_children() {
		$this->inline_children = [];
		$this->stack_boxes = [];
		$current_stack_box = [];
		foreach($this->html_element->get_children() as $child) {
			if($child->get_box_values()['is_inline'] == 1) {
				$this->inline_children[] = $child;
				$current_stack_box[] = $child;
			} else {
				if($current_stack_box->length > 0) {
					$this->stack_boxes[] = $current_stack_box;
					$current_stack_box = [];
				}
				if($this->stack_boxes->length > 0) {
					$this->stack_boxes[] = [$child];
				}
			}
		}
		if($current_stack_box->length > 0) {
			$this->stack_boxes[] = $current_stack_box;
		}
		if($this->inline_children->length > 0) {
			$this->contains_inline_elements = true;
		} else {
			$this->contains_inline_elements = false;
		}
		$parent_element = $this->html_element;


		return $this->stack_boxes;
		/*$results = [];
		foreach($this->stack_boxes as $stack) {
			$object->log('stack');
			if($stack->length > 0) {
				$pseudo_element = new html_element($parent_element->get_window(), $parent_element);
				$pseudo_element->init_pseudo();
				foreach($stack as $layout_item) {
					$object->log('add child layout');
					$pseudo_element->add_child($layout_item);
				}
				$object->log('pseud element');
				$results[] = $pseudo_element;
			}
		}
		return $results;*/
	}
	public function get_box() {
		$basic_values = $this->html_element->get_box_values();
		$main_box = [...$basic_values];
		$results = ['main_box' => $main_box];
		$set_inner_box = $main_box;
		$outest = $main_box;
		if($object->isset($basic_values['padding'])) {
			$padding_box = $this->get_margin_box($basic_values['padding'], $set_inner_box);
			$results['padding_box'] = $padding_box;
			$set_inner_box['horizontal_alignment'] = 1;
			$set_inner_box['vertical_alignment'] = 1;
			$set_inner_box = $padding_box;
			$outest = $padding_box;
		}
		if($object->isset($basic_values['border'])) {
			$set_inner_box['set_height'] = $set_inner_box['set_height'] + ($basic_values['border']['value']*2);
			$set_inner_box['set_width'] = $set_inner_box['set_width'] + ($basic_values['border']['value']*2);
		}
		if($object->isset($basic_values['margin'])) {
			$margin_box = $this->get_margin_box($basic_values['margin'], $set_inner_box);
			$results['margin_box'] = $margin_box;
			$set_inner_box['horizontal_alignment'] = 1;
			$set_inner_box['vertical_alignment'] = 1;
			$outest = $margin_box;
		}
		if($this->html_element->get_parent()->is_pseudo()) {
			if($basic_values['is_inline']) {
				$outest['vertical_alignment'] = 2;
			}
		} else {
			if($object->isset($basic_values['horizontal_alignment'])) {
				$outest['horizontal_alignment'] = $basic_values['horizontal_alignment'];
			}
			if($object->isset($basic_values['vertical_alignment'])) {
				$outest['vertical_alignment'] = $basic_values['vertical_alignment'];
			}
		}
		$results['outest'] = $outest;
		return $results;
	}
	public function check_bounds() {
		$horizontal_end_width = $this->html_element->get_layout()->get_horizontal_end();
		$container_width = $this->html_element->get_layout()->get_width();
		$parent_element = $this->html_element->get_parent();
		if(true || $horizontal_end_width > $container_width) {
			$total_width = 0;
			$set_index = -1;
			$stack_boxes = [];
			$pseudo_element = new html_element($parent_element->get_window(), $parent_element);
			$pseudo_element->init_pseudo();
			foreach($parent_element->get_original_children() as $index => $child) {
				$child_width = $child->outer_bounds()['size']['width'];
				$total_width = $total_width + $child_width;
				if($total_width > $container_width) {
					$total_width = $child_width;
					$stack_boxes[] = $pseudo_element;
					$pseudo_element = new html_element($parent_element->get_window(), $parent_element);
					$pseudo_element->init_pseudo();
				}
				$pseudo_element->add_child($child);
			}
			$stack_boxes[] = $pseudo_element;
		}
	}
	public function get_margin_box($value, $main_box) {
		$value = $value['value'];
		$results = $object->create();
		$rectangle = [-1, -1, -1, -1];
		$rectangle_type = [0, 0, 0, 0];
		$results['set_rectangle'] = $rectangle;
		$results['rectangle_type'] = $rectangle_type;
		$results['set_height'] = 2*$value + $main_box['set_height'];
		$results['set_width'] = 2*$value + $main_box['set_width'];
		return $results;
	}
}
?>

